<?php
// DataBase Configuration
$servername = "localhost"; // Server Name
$username = "calank_Guest"; //SQL Username
$password = "WTBH83LmnNFg";
$dbname = "calank_Client_Support_System";

// Creates the database connection
$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: ". $conn->connect_error);
}
else{
    echo "Connected succesfully";
}

// secret key for hashing
define('HASH_SECRET', 'your-hmac-secret-key');

// hashing data such as the email address and phone number
function hashData($data) {
    return hash_hmac('sha256', $data, HASH_SECRET);
}


$name = $email = $phone = $organisation = $issue = "";
$ticketSuccess ="";
$ticketissue = "";

// handles the submission of the form
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = $_POST['name'];
    $email = hashData($_POST['email_address']);
    $phone = hashData($_POST['phone_number']);
    $organisation = $_POST['organisation'];
    $issue = $_POST['issue'];
    $urgency = $_POST['urgency'];
    $category = $_POST['category'];
    
    $category = $conn->real_escape_string($category);
    $specialist = isset($_POST['specialist']) ? 'yes' : 'no';
    
    //used to prevent SQL injection
    $name = $conn->real_escape_string($name);
    $email = $conn->real_escape_string($email);
    $phone = $conn->real_escape_string($phone);
    $organisation = $conn->real_escape_string($organisation);
    $issue = $conn->real_escape_string($issue);
    $category = $conn ->real_escape_string($category);
    
    // used to check if the organisation has a valid contract
    $org_check_sql = "SELECT * FROM organisation WHERE organisation_name = '$organisation'";
    $result = $conn->query($org_check_sql);
    if ($result === false) {
        die("SQL Error: . $conn->error");
    }
    
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
    
    if ($row["contract_validity"] === "Yes") {
    // account manager for the organisation    
    $manager_sql = "SELECT id, name, email_address FROM account_manager
    WHERE id = (SELECT account_manager_id FROM organisation WHERE organisation_name = '$organisation')";
    $manager_result = $conn->query($manager_sql);
    
    
    if($manager_result->num_rows > 0) {
        $manager_row = $manager_result->fetch_assoc();
        $account_manager_name = $manager_row['name'];
        $account_manager_email = $manager_row['email_address'];
    
    } else {
        $account_manager_name = "Unavaliable";
        $account_manager_email = "Unavaliable";
        echo "No account manager found for this organisation.<br>";
    }
        
    // inserting client into the database   
    $client_sql = "INSERT INTO client (name, email_address, phone_number, organisation)
    VALUES ('$name', '$email', '$phone', '$organisation')";
    
    if ($conn->query($client_sql) === TRUE) {
        $client_id = $conn->insert_id;
        
        // support ticket being inserted
        $ticket_sql = "INSERT INTO tickets (client_id, issue_description, status_type, urgency, category,specialist)
        VALUES ('$client_id', '$issue', 'open', '$urgency', '$category', '$specialist') ";
        
        if ($conn->query($ticket_sql) === TRUE) {
            $ticket_id = $conn->insert_id;
            
            // Specialist being assigned if they are required
            if ($specialist === 'yes') {
                $category_normalised = strtolower(str_replace(' ', '', $category));
                $specialist_sql = "SELECT * FROM specialists WHERE REPLACE(LOWER(skills), ' ', '') LIKE '%$category_normalised%' AND workload < 8
                ORDER BY workload ASC LIMIT 1";
                $result = $conn->query($specialist_sql);
                
                if ($result->num_rows > 0){
                    $specialist_row = $result->fetch_assoc();
                    $specialist_id = $specialist_row['id'];
                    $specialist_name = $specialist_row['name'];
                    $specialist_email_address = $specialist_row['email_address'];
                    
                    $update_ticket_sql = "UPDATE tickets SET specialist_id = '$specialist_id' WHERE ticket_id = '$ticket_id'";
                    $conn->query($update_ticket_sql);
                    
                    $increment_workload_sql = "UPDATE specialists SET workload = workload + 1 WHERE id = '$specialist_id'";
                    $conn->query($increment_workload_sql);
                    

                }
            }
            
            // Agent with the least tickets are assigned
            $agent_sql = "SELECT a.agent_id, a.name, a.email_address, a.phone_number
            FROM agents a 
            LEFT JOIN tickets t ON a.agent_id = t.agent_id
            GROUP BY a.agent_id 
            ORDER BY COUNT(t.ticket_id) ASC LIMIT 1";
            
            $agent_result = $conn->query($agent_sql);
            
            if ($agent_result && $agent_result->num_rows > 0 ) {
                $agent_row = $agent_result-> fetch_assoc();
                $agent_id = $agent_row['agent_id'];
                $agent_name = $agent_row ['name'];
                $agent_email = $agent_row['email_address'];
                $agent_phone_number = $agent_row['phone_number'];
                
                $conn->query("UPDATE tickets SET agent_id = '$agent_id' WHERE ticket_id = '$ticket_id'");
                $ticketSuccess .="<br>Assigned Agent: <strong> $agent_name</strong> ($agent_email, $agent_phone_number)";

                
                
            } else {
                $ticketSuccess .= "<br> No Avaliable Agent At The Moment.";
            }
        
            } else {
                $ticketissue = "Error saving ticket details" . $conn->error;
            }
    
    

            
            $ticketSuccess = "The support ticket has been submitted succesfully!<br>
            Ticket Number: <strong>#{$ticket_id}</strong><br>
            Your Account Manager is $account_manager_name ($account_manager_email).";
            $ticketSuccess .="<br>Assigned Agent: <strong> $agent_name</strong> ($agent_email)";
            
            if ($specialist === 'yes') {
                if (isset($specialist_name)) {
            $ticketSuccess .= "<br>Specialist Assigned: <strong>" . htmlspecialchars($specialist_name) . "</strong> (" . htmlspecialchars($specialist_email_address) . ")";
            
            } else {
                $ticketSuccess .="<br>No specialist avaliable, reccomending another specialist.";
            }
            }
            
        } else {
            $ticketissue = "Error submitting ticket:" . $conn->error;
        }
        
    } else {
        $ticketissue = "Error saving client details:" .$conn->error;
    }
    

    } else {
    $ticketissue = "Your Organisation does not have a valid contract with iTech Solutions";
    }
 }


    



 $conn->close();
 ?>
 
 <!DOCTYPE html>
 <html lang="en">
 <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Submit Ticket</title>
 </head>
 <body>
     <body>
    <h1 style="text-align: center; color: #003366; font-family: Arial, sans-serif;">iTech Solutions</h1>
    <h2 style="text-align: center;">Support Ticket Form</h2>
     <h2>Submit Ticket</h2>
     <p>
         <a href="existing_solutions.php" target="blank" style="text-decoration: none; color: blue;">
             Search for Exisitng Solutions
             
         </a><br>
         
         <a href="progress_log.php" target="blank" style="text-decoration: none; color; blue;">
             Ticket Progress Log
         </a><br>
         
         <a href="followupqueries.php" target="blank" style="text-decoration: none; color; blue">
             Follow Up Queries
         </a><br>
         
         <a href="dashboard.php" target="blank" style="text-decoration: none; color; blue;">
             Dashboard Reporting
         </a>
     </p>
     
     <?php if (!empty($ticketSuccess)): ?>
        <p style="color: green;"><?php echo $ticketSuccess; ?></p>
     <?php endif; ?>
     
     <?php if (!empty($ticketissue)): ?>
        <p style="color: red;"><?php echo $ticketissue; ?></p>
     <?php endif; ?>
     
     <form action="support_form.php" method="POST">
         
         Full Name: <input type="text" name="name" required><br><br>
         Email: <input type="email" pattern="[a-z0-9._+_]+@[a-z0-9.-]+\.[a-z]{2,4}$" name="email_address" required><br><br>
         Phone Number:  <input type="text" name="phone_number" required><br><br>
         Organisation Name : <input type="text" name="organisation"required><br><br>
         
         <label for="issue">Description Of Issue:</label><br>
         <textarea id="issue" name="issue" rows="5" cols="50" required></textarea><br><br>
         <label for="urgency">Urgency Level:</label><br>
         <select name="urgency" required>
             <option value="Low">Low</option>
             <option value="Medium">Medium</option>
             <option value="High">High</option>
        </select><br><br>
        
        <label for="category">category:</label>
        <select name="category" required>
            <option value="Software">Software</option>
            <option value="Performance">Performance</option>
            <option value="Login Problems">Login Problems</option>
            <option value="Network Issue">Network Issues</option>
            <option value="Installation Issue">Installation Issue</option>
            <option value="Other">Other</option>
        </select><br><br>
         
    <label>
        <input type="checkbox" name="specialist" value="yes">
        Does this issue require a specialist!
    </label><br><br>
         <input type="Submit" value="Submit Form">
         
         
         
     </form>
     
     
     
 </body>
 </html>
