<?php
//session start for dashboard report
session_start();

include "connection.php";

if (!isset($_SESSION['Client_Fname']) || !isset($_SESSION['Client_Id'])) {
    header("Location: login.php");
    exit();
} else {

//<!--php code To complete dashboard report-->
//<?php
// This code links the tickets and ticket progress table and makes a report of how many tickets each agent has completed.
$total_ticket_sql = "SELECT COUNT(*) AS total FROM Tickets";
$total_ticket_result = $conn->query($total_ticket_sql);
$total_tickets = $total_ticket_result->fetch_assoc()['total'];

//Counts the tickets progress completed behined or on track
$progress_sql = "SELECT Progress, COUNT(*) AS count FROM Progress GROUP BY Progress";
$progress_result = $conn->query($progress_sql);

//Calculate how many tickets progress is completed
$status_sql = "SELECT COUNT(Progress = 'Completed') AS proc FROM Progress P WHERE P.Progress IS NOT NULL";


$status_result = $conn->query($status_sql);
$status_com = round($status_result->fetch_assoc() ['proc']);

// Counts all issues from most common
$issue_sql = "SELECT Issue, COUNT(*) AS total FROM Tickets GROUP BY Issue ORDER BY total DESC";
$issue_result = $conn->query($issue_sql);

//The amount of tickets each agent has handeled
$agent_sql = "SELECT a.Agent_Fname, COUNT(t.Ticket_Id) AS completed_tickets FROM Agent a JOIN Tickets t ON a.Agent_Id = t.Agent_Id JOIN Progress p ON t.Ticket_Id = p.Ticket_Id WHERE p.Progress = 'Completed' GROUP BY a.Agent_Id ORDER BY completed_tickets DESC";

$agent_result = $conn->query($agent_sql);


//Get client id for organization contract details
$Client_Id = $_SESSION['Client_Id'];

//Get clients organization from client table
$org_sql = "SELECT Organization FROM Client WHERE Client_Id = ?";
$stmt = $conn->prepare($org_sql);
$stmt->bind_param("i", $Client_Id);
$stmt->execute();
$org_result = $stmt->get_result();

if ($org_result->num_rows === 0) {
    die("There is no organization for this client");
}

$organization = $org_result->fetch_assoc()['Organization'];


//Contrct code to display contract details using organization from client

$contract_sql = "SELECT Contract_Id, Contract_Details, Contract_Validation FROM Contract WHERE Organization = ?";
$stmt = $conn->prepare($contract_sql);
$stmt->bind_param("s", $organization);
$stmt->execute();
$contract_result = $stmt->get_result();



$conn->close();


//gets client name from session
$Client_Fname = $_SESSION['Client_Fname'];
}
?>

<!--Start of html code for dashboard report-->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard report</title>
</head>

<!--Main body of Dashboard report code and navigation-->
<body>
    <h1>Welcome, <?php echo htmlspecialchars($Client_Fname, ENT_QUOTES, 'UTF-8'); ?></h1>
    
    <nav>
        <a href="ticketform.php">Ticket form</a>
        <a href="ticketprogress.php">Ticket progress</a>
        <a href="search.php">Search for solutions</a>
        <a href="logout.php">Log out</a>
    </nav>
    
    <p><strong>Total Amount of Tickets: </strong> <?= $total_tickets ?></p>
    <p><strong>Ticket progress: </strong> <?= $status_com ?></p>
    
    <h3>Progress Overview</h3>
    <ul>
        <?php while ($row = $progress_result->fetch_assoc()): ?>
            <li><?= ucfirst($row['Progress']) ?>: <?= $row['count'] ?></li>
            <?php endwhile; ?>
    </ul>
    
    <h3>Top Issues</h3>
    <ul>
        <?php while ($row = $issue_result->fetch_assoc()): ?>
        <li><?= $row['issue'] ?> (<?= $row['total'] ?> Tickets)</li>
        
        <?php endwhile; ?>
    </ul>
    
    <h3>Agent performance</h3>
    <ul>
        <?php while ($row = $agent_result->fetch_assoc()): ?>
        <li><?= htmlspecialchars($row['Agent_Fname'], ENT_QUOTES, 'UTF-8') ?> - <?=$row['completed_tickets'] ?> Tickets Completed</li>
        <?php endwhile; ?>
    </ul>
    
    
    <h3>Contract Details for Organization: <?= htmlspecialchars($organization, ENT_QUOTES, 'UTF-8') ?></h3>
    
    <table>
        <tr>
            <th>Contract Id</th>
            <th>Contract Details</th>
            <th>Contract Validation</th>
        </tr>
        <?php while ($row = $contract_result->fetch_assoc()): ?>
            <tr>
                <td><?= htmlspecialchars($row['Contract_Id'], ENT_QUOTES, 'UTF-8') ?></td>
                 <td><?= htmlspecialchars($row['Contract_Details'], ENT_QUOTES, 'UTF-8') ?></td>
                  <td><?= htmlspecialchars($row['Contract_Validation'], ENT_QUOTES, 'UTF-8') ?></td>
            </tr>
        <?php endwhile; ?>
    </table>
    
</body>
</html>
