<?php
//session start of login php
session_start();

include "connection.php";

$error = "";//This is for containing and displaying error messages
$logout_message = ""; //This is to collect and display the logout message

//If the redirect came from log out page
if (isset($_GET['message']) && $_GET['message'] === 'logout') {
    $logout_message = "You have been Logged out, thank you for your services and come again.";
} 
    
//Php code to verify login details with database information

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $Client_Fname = $_POST['Client_Fname'];
    $Client_Lname = $_POST['Client_Lname'];
    $Email = $_POST['Email'];
    $Pass_word = $_POST['Pass_word'];
    
    // An Sql statement to find and compare client data by email
    $stmt = $conn->prepare("SELECT * FROM Client WHERE Email = ?");
    $stmt->bind_param("s", $Email);
    $stmt->execute();
    $result = $stmt->get_result();
    
    //Verify email and user exists
    if ($result->num_rows === 1) {
        $Client = $result->fetch_assoc();
        
        //Verify the password with the hashed password stored in the Client DB table
        if (password_verify($Pass_word, $Client['Pass_word'])) {
            //Password is correct and client is authenticated.
            $_SESSION['Client_Id'] = $Client['Client_Id'];//unique id identifyer
            $_SESSION['Client_Fname'] = $Client['Client_Fname'];//stores first name attribute
            $_SESSION['Client_Lname'] = $Client['Client_Lname'];//stores last name attribute
            
            header("Location: ticketform.php");//redirect to ticket form page
            exit();
        } else {
            $error = "Incorrect password, please try again.";
        }
    } else {
        $error = "No Client found with this Email, please try again.";
    }
    
    $stmt->close();
}
?>


<!--Start of html coding-->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
</head>

<!--Main body of login and form data-->
<body>
    
    <!--php code for log out redirect message-->
    <?php
    if (!empty($logout_message)) {
        echo "<p style='color:green;'>$logout_message</p>";
    }
    
    //error message just in case something goes wrong
    if (!empty($error)) {
        echo "<p style='color:red;'>$error</p>";
    }
    ?>
    
    <!--Client login form-->
    <h1>Client Login</h1>
    <form action="login.php" method="POST" autocomplete="off">
        First_Name: <input type="text" name="Client_Fname" placeholder="John" autocomplete="off" required><br><br>
        Last_Name: <input type="text" name="Client_Lname" placeholder="Smith" autocomplete="off" required><br><br>
        Email: <input type="email" name="Email" pattern="[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2, 4}$" placeholder="j.smith@mail.co.uk" autocomplete="off" required><br><br>
        Pass_word: <input type="password" name="Pass_word" autocomplete="off" required><br><br>
        <input type="submit" value="Login">
        
    </form>
</body>
</html>