<?php
//session start for log out php
session_start();

include "connection.php";

//This is to unset all session variables from pages
$_SESSION = array();

//This will delete any session cookies so data can't be stolen and so hackers can't see previous login credentials.
if (ini_get("session.use_cookies")){
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000, $params["path"], $params["domain"], $params["secure"], $params["httponly"]
    );
}

//Delete all the cookies that are not necessary
foreach ($_COOKIE as $key => $value) {
    setcookie($key, '', time() - 3600, '/');
}



//This will destroy the session
session_destroy();


//This will redirect the user to login
header("Location: login.php?message=logout");
exit();
?>