<?php
//Session start for serch page
session_start();

//link to database php
include "connection.php";

//verifys client is logged in
if (!isset($_SESSION['Client_Fname']) || !isset($_SESSION['Client_Id'])) {
    header("Location: login.php");
    exit();
}

//Getting clients First name from session
$Client_Fname = $_SESSION['Client_Fname'];

?>


<!--Start of html code for Search page-->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Search for Existing solutions</title>
</head>

<!--Main body of search form html data-->
<body>
    <h1>Welcome <?php echo htmlspecialchars($Client_Fname, ENT_QUOTES, 'UTF-8'); ?></h1>
    
    <nav>
        <a href="ticketform.php">Ticket Form</a>
        <a href="ticketprogress.php">Ticket Progress</a>
        <a href="dashboard.php">Dashboard report</a>
        <a href="logout.php">Logout</a>
    </nav>
    
    <h2>Search form</h2>
    <form action="search.php" method="GET" autocomplete="off">
        <label for="keyword">Search:</label>
        <input type="text" id="keyword" name="keyword" placeholder="Login" autocomplete="off" required><br><br>
        <button type="submit">Search</button>
    </form>
</body>
</html>

<!--Php code to handel the search and collect the data-->
<?php

if (isset($_GET['keyword'])) {
    $keyword = trim($_GET['keyword']);
    
    //This is to verify client input
    if (strlen($keyword) < 2) {
        echo "Search keyword must atlease be longer than 2 characters.";
        exit();
    }
    
    //Prevents clients from doing sql injection
    $keyword = "%" . $conn->real_escape_string($keyword) . "%";
    
//This will execute the query safely and securely
$stmt = $conn->prepare("SELECT Solution_Id, Solution_Text FROM Solutions WHERE Solution_Text LIKE ?");
$stmt->bind_param("s", $keyword);
$stmt->execute();
$result = $stmt->get_result();

//This will display the results in a table format
if ($result->num_rows > 0) {
    echo "<h2>Search Results for: " . htmlspecialchars($keyword, ENT_QUOTES, 'UTF-8') . "</h2>";
    echo "<table border='1' cellpadding='10'>
            <tr>
                <th>Solution Id</th>
                <th>Solution Text</th>
                <th>keyword</th>
            </tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>
                <td>" . htmlspecialchars($row['Solution_ID'], ENT_QUOTES, 'UTF-8') . "</td>
                <td>" . htmlspecialchars($row['Solution_Text'], ENT_QUOTES, 'UTF-8') . "</td>
            </tr>";
            
    }
    echo "</table>";
} else {
    echo "No Solutions Found for: ". htmlspecialchars($keyword, ENT_QUOTES, "UTF-8");
}
$stmt->close();
$conn->close();
}
?>