<?php
//starts session
session_start();

//short cut link to Connection to database php
include "connection.php";

//php code to insert/add attributes to the Customer table in the database

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    //capture form inputs
    $Client_Fname = $_POST['Client_Fname'];
    $Client_Lname = $_POST['Client_Lname'];
    $Email = $_POST['Email'];
    $Pass_word =password_hash($_POST['Pass_word'], PASSWORD_DEFAULT);
    $Phone = $_POST['Phone'];
    $Organization = $_POST['Organization'];
    
    // Insert data into database table client stmt to make the programme secure from sql injections
    $stmt = $conn->prepare("INSERT INTO Client (Client_Fname, Client_Lname, Email, Pass_word, Phone, Organization) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssss", $Client_Fname, $Client_Lname, $Email, $Pass_word, $Phone, $Organization);
    
    if ($stmt->execute()) {
        header("Location: login.php");// redirect
        exit();
    } else {
        echo "Sign up failed, please try again.";
    }
    $stmt->close();
    
}

?>

<!--Start of html coding-->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sign Up</title>
</head>

<!--Main body of html code and form data-->
<body>
    <h1>Client Signup</h1>
    <form action="signup.php" method="POST" autocomplete="off">
        First_Name: <input type="text" name="Client_Fname" placeholder="John" autocomplete="off" required><br><br>
        Last_Name: <input type="text" name="Client_Lname" placeholder="Smith" autocomplete="off" required><br><br>
        Email: <input type="email" name="Email" pattern="[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2, 4}$" placeholder="j.smith@mail.co.uk" autocomplete="off" required><br><br>
        Pass_word: <input type="password" name="Pass_word" autocomplete="off" required><br><br>
        Phone_Number: <input type="tel" name="Phone" placeholder="123-45-678" pattern="[0-9]{3}-[0-9]{2}-[0-9]{3}" autocomplete="off" required><br><br>
        Organization_Name: <input type="text" name="Organization" autocomplete="off" required><br><br>
        <input type="submit" value="Signup">
    </form>
    <!--link to login page if user already has an account-->
    <p><a href="login.php">Already have an account? Login here</a></p>
</body>
</html>
