<?php
//Session start for ticket form
session_start();

include "connection.php";

// check if client is logged in
if (!isset($_SESSION['Client_Fname']) || !isset($_SESSION['Client_Id'])){
    header("Location: login.php");
    exit();
} 
    if ($_SERVER["REQUEST_METHOD"] == "POST"){
    $Issue = $_POST['Issue'];
    $Urgency = $_POST['Urgency'];
    $Client_Id = $_SESSION['Client_Id'];
    $Client_Fname = $_SESSION['Client_Fname'];
    $Organization = $_SESSION['Organization'];
    //generates a ran unique ticket num for the client
    $Ticket_Number = uniqid('TKT-');
    //Will check if the client has answered yes for the agents help
    $Agent_Needed = isset($_POST['Agent']) ? 1 : 0;
    
    //This will pull organization from Client table properly so it can be added to Ticket table
    $sql_org = $conn->prepare("SELECT Organization FROM Client WHERE Client_Id = ?");
    $sql_org->bind_param("i", $Client_Id);
    $sql_org->execute();
    $result_org = $sql_org->get_result();
    
    if ($result_org->num_rows > 0) {
        $row = $result_org->fetch_assoc();
        $Organization = $row['Organization'];
    } else {
        $Organization = "Doesn't exist"; // Just incase an error occurs
    }
    
    
    
    //Agent values are default so the table can collect it from the table in the db
    $Agent_Id = $Agent_Id ?? 0;
    $Agent_Fname = $Agent_Fname ?? 'Unassigned';
    
    if ($Agent_Needed){
        //Will select the Agent that matches your issue
        $sql_agent = $conn->prepare("SELECT Agent_Id, Agent_Fname FROM Agent WHERE Skill = ?");
        $sql_agent->bind_param("s", $Issue);
        $sql_agent->execute();
        $result = $sql_agent->get_result();
        
        if ($result->num_rows > 0) {
            $Agent = $result->fetch_assoc();
            $Agent_Id = $Agent['Agent_Id'];
            $Agent_Fname = $Agent['Agent_Fname'];
            
        }
    }
    
    //Insert data Into Tickets
    $stmt = $conn->prepare("INSERT INTO Tickets(Ticket_Number, Client_Id, Client_Fname, Organization, Issue, Urgency, Agent_Id, Agent_Fname) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sissssis", $Ticket_Number, $Client_Id, $Client_Fname, $Organization, $Issue, $Urgency, $Agent_Id, $Agent_Fname);
    
    if ($stmt->execute()) {
        // Gets the auto incremented Ticket Id
        $Ticket_Id = $stmt->insert_id;
        
        
        echo "Ticket successfully created: Here is your Ticket Number: $Ticket_Number";
        
        //insert into the junction Table Agent_Ticket
        if ($Agent_Needed && $Agent_Id > 0) {
    $check_link = $conn->prepare("SELECT 1 FROM Agent_Tickets WHERE Agent_Id = ? AND Ticket_Id = ?");
    $check_link->bind_param("ii", $Agent_Id, $Ticket_Id);
    $check_link->execute();
    $check_link->store_result();
    
    if ($check_link->num_rows === 0) {
        //This will only insert the ticket if it doesn't exist
        $link_Agent_Ticket = $conn->prepare("INSERT INTO Agent_Tickets (Agent_Id, Ticket_Id) VALUES (?, ?)");
        $link_Agent_Ticket->bind_param("ii", $Agent_Id, $Ticket_Id);
        if ($link_Agent_Ticket->execute()) {
            echo "<br>Agent-Ticket Relationship link Successful.";
        } else {
            //echo "<br>Something went wrong with Agent to Ticket link: " . $link_Agent_Ticket->error;
            }
        
    } else {
        echo "<br>This Agent-Ticket relationship already exists. No duplicate links";
        }
    } 
} else {
    error_log("Ticket insert Error: " . $stmt->error);
    echo "There was an issue with the tickets creation, please try again.";
    }
}



//Get Client first name from session
$Client_Fname = $_SESSION['Client_Fname'];
?>

<!--Start of ticket form code-->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ticket form</title>
</head>

<!--Main body of the ticket code and form data-->
<body>
    <!--Client welcome message-->
    <h1>Welcome, <?php echo htmlspecialchars($Client_Fname, ENT_QUOTES, 'UTF-8'); ?></h1>
        <nav>
            <a href="ticketprogress.php">Ticket progress</a>
            <a href="search.php">Search for solutions</a>
            <a href="dashboard.php">Dashboard report</a>
            <a href="logout.php">Logout</a>
        </nav>
    
    
    <!--Ticket form catagorys-->
    <h2>Ticket form</h2>
    <form action="ticketform.php" method="POST">
        <label for="Issue">Select the Issue catagory that is your problem</label>
        <select id="Issue" name="Issue" required>
            <option value="">Select an Issue catagory</option>
            <option value="Software">Software</option>
            <option value="Performance">Performance</option>
            <option value="Login">Login</option>
        </select><br><br>
        <select id="Urgency" name="Urgency" required>
            <option value="">Select urgency</option>
            <option value="Low">Low</option>
            <option value="Medium">Medium</option>
            <option value="High">High</option>
            <option value="Emergency">Emergency</option>
        </select><br><br>
        <label for="Agent">Is a Agent required?</label> 
        <input type="checkbox" id="Agent" name="Agent" value="1"><br><br>
        <button type="submit">Generate Ticket</button>
        
    </form>
</body>
</html>