<?php
//Session start for ticket progress
session_start();

include "connection.php";

if (!isset($_SESSION['Client_Fname']) || !isset($_SESSION['Client_Id'])) {
    header("Location: login.php");
    exit();
} else {
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $Progress = $_POST['Progress'];
    $Solution = htmlspecialchars(trim($_POST['Solution']), ENT_QUOTES, 'UTF-8');
    $date = $_POST['date'];
    $Client_Id = $_SESSION['Client_Id'];
    $Client_Fname = $_SESSION['Client_Fname'];
    $Organization = $_SESSION['Organization'];
    $Ticket_Id = $_POST['Ticket_Id'];// this is to collect the ticket id from form input if this client has multiple tickets.
    $Ticket_Number = $_SESSION['Ticket_Number'];
    $Issue = $_SESSION['Issue'];
    
    //Collecting client data from the client table
    $sql_client = $conn->prepare("SELECT Client_Fname, Organization FROM Client WHERE Client_Id = ?");
    $sql_client->bind_param("i", $Client_Id);
    $sql_client->execute();
    $result_client = $sql_client->get_result();
    
    if ($result_client->num_rows > 0) {
        $Client_Data = $result_client->fetch_assoc();
        $Client_Fname = $Client_Data['Client_Fname'];
        $Organization = $Client_Data['Organization'];
    } else {
        echo "Data can't be found, please try again";
    }
    
    
    //Collecting the ticket data from ticket table
    $sql_ticket = $conn->prepare("SELECT Ticket_Number, Issue FROM Tickets WHERE Ticket_Id = ?");
    $sql_ticket->bind_param("i", $Ticket_Id);
    $sql_ticket->execute();
    $result_ticket = $sql_ticket->get_result();
    
    if ($result_ticket->num_rows > 0) {
        $Ticket_Data = $result_ticket->fetch_assoc();
        $Ticket_Number = $Ticket_Data['Ticket_Number'];
        $Issue = $Ticket_Data['Issue'];
    } else {
        echo "Ticket can't be found, please try again.";
        exit();
    }
    
    //Insert into progress
    $stmt = $conn->prepare("INSERT INTO Progress(Progress, Solution, date, Client_Id, Client_Fname, Organization, Ticket_Id, Ticket_Number, Issue) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssississ", $Progress, $Solution, $date, $Client_Id, $Client_Fname, $Organization, $Ticket_Id, $Ticket_Number, $Issue);
    
    if ($stmt->execute()) {
        echo "Ticket Progress Successfully Inserted and stored.";
    } else {
        echo "Ticket progress Insert Failed, Try again: " . $stmt->error;
    }
}
}

// Get clients first name from session 
$Client_Fname = $_SESSION['Client_Fname'];

//This code collects all tickets linked with logged in client_Id so if there is more than 1 ticket in the client
$Client_Id = $_SESSION['Client_Id'];
$tickets = [];

$sql = $conn->prepare("SELECT Ticket_Id, Ticket_Number, Issue FROM Tickets WHERE Client_Id = ?");
$sql->bind_param("i", $Client_Id);
$sql->execute();
$result = $sql->get_result();

while ($row = $result->fetch_assoc()) {
    $tickets[] = $row;
}
?>

<!--Start of html code for ticket progress page-->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ticket progress</title>
</head>

<!--Main body of ticket progress code and form data-->
<body>
    <h1>Welcome, <?php echo htmlspecialchars($Client_Fname, ENT_QUOTES, 'UTF-8'); ?></h1>
    
    <nav>
        <a href="ticketform.php">Ticket form</a>
        <a href="search.php">Search for solutions</a>
        <a href="dashboard.php">Dashboard report</a>
        <a href="logout.php">Logout</a>
    </nav>
    
    <h2>Ticket progress form</h2>
    <form action="ticketprogress.php" method="POST">
        <label for="Progress">Select on how the Ticket progress is going</label>
        <select id="Progress" name="Progress" required>
            <option value="">Select progress complition</option>
            <option value="Behind">Behind</option>
            <option value="On Track">On Track</option>
            <option value="Completed">Completed</option>
        </select><br><br>
        <!--Select Ticket id So just incase there is more than 1 ticket-->
        <label for="Ticket_Id">Select the Ticket Id:</label>
        <select name="Ticket_Id" id="Ticket_Id" required>
            <option value="">Select Ticket</option>
            <?php foreach ($tickets as $ticket): ?>
            <option value="<?php echo $ticket['Ticket_Id']; ?>">Ticket #<?php echo htmlspecialchars($ticket['Ticket_Number']); ?> - <?php echo htmlspecialchars($ticket['Issue']); ?></option>
            <?php endforeach; ?>
        </select>
        <!-- This creates a text area so the client can see their input-->
        Solution: <textarea name="Solution" rows="5" cols="10" placeholder="Enter Your solution"></textarea><br><br>
        <!--This creates a selector to choose a date from a calander-->
        date: <input type="date" id="date" name="date" required><br><br>
        <button type="submit">Submit</button>
    </form>
</body>
</html>